(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10459,        310]
NotebookOptionsPosition[      9834,        283]
NotebookOutlinePosition[     10227,        300]
CellTagsIndexPosition[     10184,        297]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " Example: Circumcircle\n\n",
 StyleBox["This example demonstrates some techniques for creating interactive \
user interfaces with ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" code. It shows:\n\t- drawing into a PictureBox with ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" code\n\t- the ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DoNETModal",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" function\n\t- the use of ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["AddEventHandler",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" to wiire up some simple ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" functions for event callbacks\n\nThe program allows you to click \
three points to define the vertices of a triangle, and then it draws the \
circumcircle (the circle that passes through all three vertices) and \
demonstrates that the perpendicular bisectors of the sides of the triangle \
intersect at the circumcenter, the center of the circumcircle. For more \
information on the cicumcircle and related concepts, see the ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[ButtonBox["MathWorld page for Circumcircle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://mathworld.wolfram.com/Circumcircle.html"], None}],
  FontSize->12],
 StyleBox[".\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Section"],

Cell["\<\
Needs[\"NETLink`\"]

(* Determines the circumcircle of a triangle. Code from Eric Weisstein's \
PlaneGeometry.m, available on MathWorld. *)
Circumcircle[{{x1_,y1_}, {x2_,y2_}, {x3_,y3_}}] :=
\tModule[{a, d, f, g},
\t\ta = Det[{{x1,y1,1}, {x2,y2,1}, {x3,y3,1}}];
\t\td = -1/2 Det[{{x1^2+y1^2,y1,1}, {x2^2+y2^2,y2,1}, {x3^2+y3^2,y3,1}}];
\t\tf = 1/2 Det[{{x1^2+y1^2,x1,1}, {x2^2+y2^2,x2,1}, {x3^2+y3^2,x3,1}}];
\t\tg = -Det[{{x1^2+y1^2,x1,y1}, {x2^2+y2^2,x2,y2}, {x3^2+y3^2,x3,y3}}];
\t\tCircle[{-d/a,-f/a}, Sqrt[(f^2+d^2)/a^2-g/a]]
\t]


(* This is the function that is called to update the Image that the \
PictureBox holds. Although it creates
   temporary .NET objects, there is no need to wrap it in NETBlock because it \
is only called from event callback
   functions (onMouseMove and onMouseDown), which are always implicitly \
wrapped in NETBlock by the internals
   of .NET/Link.
*)
updateImage[pictureBox_?NETObjectQ, vertices_List, {blackPen_, redPen_, \
bluePen_, blackBrush_}] :=
\tModule[{offScreenBmp, g, circumCenter, circumRadius, midPoints},
\t\t(* Create an offscreen bitmap and obtain a Graphics object from it that \
we can use to draw
\t\t   into the bitmap.
\t\t*)
\t\toffScreenBmp = NETNew[\"System.Drawing.Bitmap\", pictureBox@Width, \
pictureBox@Height]; 
\t\tg = Graphics`FromImage[offScreenBmp];
\t\t
\t\t(* Draw the various lines, points, and circle. For some reason, \
FillEllipse alone doesn't create a nice small
\t\t   filled circle, so we also call DrawEllipse to fill in some points on \
the boundary.
\t\t*)
\t\tg@FillEllipse[blackBrush, #1, #2, 6, 6]& @@@ (vertices - 3); 
\t\tg@DrawEllipse[blackPen, #1, #2, 6, 6]& @@@ (vertices - 3);
\t\tg@DrawLine[blackPen, #1[[1]], #1[[2]], #2[[1]], #2[[2]]]& @@@ \
Partition[vertices ~Append~ First[vertices], 2, 1];
\t\tIf[Length[vertices] == 3,
\t\t\t{circumCenter, circumRadius} = Round[List @@ Circumcircle[vertices]];
\t\t\tg@DrawEllipse[redPen, #1, #2, 6, 6]& @@ (circumCenter - 3);  (* 3 is \
the radius of the points for vertices. *)
\t\t\tg@DrawEllipse[bluePen, #1, #2, 2 circumRadius, 2 circumRadius]& @@ \
(circumCenter - circumRadius);
\t\t\tmidpoints = Round[(#1 + #2)/2 & @@@ Partition[vertices ~Append~ \
First[vertices], 2, 1]];
\t\t\tg@DrawLine[redPen, #1, #2, circumCenter[[1]], circumCenter[[2]]]& @@@ \
midpoints;
\t\t];
\t\t
\t\t(* Set the pictureBox's Image to be the bitmap we have just created and \
drawn into. Call Refresh() to
\t\t   force an immediate redraw, which improves smoothness of the animation \
while dragging.
\t\t*)
\t\tpictureBox@Image = offScreenBmp;
\t\tpictureBox@Refresh[]
\t]
\t
\t
CircumcircleInteractive[] :=
\tNETBlock[
\t\tModule[{form, pictureBox, vertices, draggingVertex, onMouseMove, \
onMouseDown, lastX, lastY,
\t\t\t\t\tblackBrush, redPen, bluePen, blackPen},
\t\t\tInstallNET[];
\t\t\t
\t\t\t(* First load some classes from which we need to call static members. \
No assemblies need to be loaded
\t\t\t   because the System.Windows.Forms and System.Drawing assemblies are \
preloaded by .NET/Link.
\t\t\t*)
\t\t\tLoadNETType[\"System.Drawing.Color\"];
\t\t\tLoadNETType[\"System.Windows.Forms.DockStyle\"];
\t\t\tLoadNETType[\"System.Windows.Forms.Cursors\"];
\t\t\tLoadNETType[\"System.Drawing.Graphics\"];
\t\t\t
\t\t\t(* Now create the main form and picturebox, and set the desired \
properties. *)
\t\t\tform = NETNew[\"System.Windows.Forms.Form\"];
\t\t\tform@Text = \"Circumcircle\";
\t\t\tform@Width = 350;
\t\t\tform@Height = 350;
\t\t\tpictureBox = NETNew[\"System.Windows.Forms.PictureBox\"];
\t\t\tpictureBox@Parent = form;
\t\t\tpictureBox@Dock = DockStyle`Fill;
\t\t\tpictureBox@BackColor = Color`LightGray;
\t\t\t
\t\t\t(* Create these drawing resources just once and reuse them in every \
call to updateImage[]. *)
\t\t\tblackBrush = NETNew[\"System.Drawing.SolidBrush\", Color`Black];
\t\t\tredPen = NETNew[\"System.Drawing.Pen\", Color`Red];
\t\t\tbluePen = NETNew[\"System.Drawing.Pen\", Color`Blue];
\t\t\tblackPen = NETNew[\"System.Drawing.Pen\", Color`Black];
\t\t\t
\t\t\t(* Wire up the event callbacks. *)
\t\t\tAddEventHandler[pictureBox@MouseDown, onMouseDown];
\t\t\tAddEventHandler[pictureBox@MouseMove, onMouseMove];
\t\t\tAddEventHandler[pictureBox@MouseUp, Clear[draggingVertex]&];
\t\t\t
\t\t\t(* Define the event callback functions. *)
\t\t\tonMouseDown[sender_, mouseEvtArgs_] :=
\t\t\t\tModule[{xPos, yPos},
\t\t\t\t\t{xPos, yPos} = {mouseEvtArgs@X, mouseEvtArgs@Y};
\t\t\t\t\tIf[Length[vertices] < 3,
\t\t\t\t\t\tAppendTo[vertices, {xPos, yPos}];
\t\t\t\t\t\tupdateImage[sender, vertices, {blackPen, redPen, bluePen, \
blackBrush}],
\t\t\t\t\t(* else *)
\t\t\t\t\t\tdraggingVertex = 
\t\t\t\t\t\t\tScan[
\t\t\t\t\t\t\t\tIf[Sqrt[(#[[1,1]] - xPos)^2 + (#[[1,2]] - yPos)^2] < 6,
\t\t\t\t\t\t\t\t\tReturn[#[[2]]]
\t\t\t\t\t\t\t\t]&,
\t\t\t\t\t\t\t\tThread[{vertices, {1,2,3}}]
\t\t\t\t\t\t\t];
\t\t\t\t\t\tIf[IntegerQ[draggingVertex],
\t\t\t\t\t\t\t{lastX, lastY} = {xPos, yPos};
\t\t\t\t\t\t]
\t\t\t\t\t]
\t\t\t\t];
\t\t\tonMouseMove[sender_, mouseEvtArgs_] :=
\t\t\t\tModule[{xPos, yPos, isCloseToAnyVertex},
\t\t\t\t\t{xPos, yPos} = {mouseEvtArgs@X, mouseEvtArgs@Y};
\t\t\t\t\tWhich[
\t\t\t\t\t\tIntegerQ[draggingVertex],
\t\t\t\t\t\t\t(* Do the drag *)
\t\t\t\t\t\t\tvertices[[draggingVertex]] += {xPos - lastX, yPos - lastY};
\t\t\t\t\t\t\t{lastX, lastY} = {xPos, yPos};
\t\t\t\t\t\t\tupdateImage[sender, vertices, {blackPen, redPen, bluePen, \
blackBrush}],
\t\t\t\t\t\tLength[vertices] == 3,
\t\t\t\t\t\t\t(* Set the Hand cursor if close to any of the vertices. *)
\t\t\t\t\t\t\tisCloseToAnyVertex = Scan[If[Sqrt[(#[[1]] - xPos)^2 + (#[[2]] - \
yPos)^2] < 6, Return[True]]&, vertices];
\t\t\t\t\t\t\tsender@Cursor = If[TrueQ[isCloseToAnyVertex], Cursors`Hand, \
Cursors`Arrow]
\t\t\t\t\t];
\t\t\t\t];
\t\t\t\t
\t\t\t(* Initialize and run modally. *)
\t\t\tvertices = {};
\t\t\tDoNETModal[form]
\t\t]
\t]\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["CircumcircleInteractive[]", "Input"],

Cell["\<\
Click the mouse three times to define the vertices of a triangle. You can \
then drag any of the vertices and watch the figure change. The blue circle is \
the circumcircle and the red lines are the perpendicular bisectors of the \
sides of the triangle. Note that the three bisectors intersect at the \
circumcenter.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{907, 631},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 2734, 82, 394, "Title"],
Cell[CellGroupData[{
Cell[3349, 109, 23, 0, 67, "Section"],
Cell[3375, 111, 5979, 153, 2244, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[9391, 269, 26, 0, 37, "Section"],
Cell[9420, 271, 42, 0, 24, "Input"],
Cell[9465, 273, 341, 6, 41, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

